<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Nineteen
 * @since Twenty Nineteen 1.0
 */
?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<link rel="profile" href="https://gmpg.org/xfn/11" />
	
		<!-- Bootstrap -->
	<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/assets/css/bootstrap.min.css">
	<!-- icon -->
	<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/assets/css/fontawsome.min.css">
	<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/assets/css/slick.css">
	<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/assets/css/slick-theme.css">
	<!--  My_Styles -->
	<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/assets/css/style.css">
	<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/assets/css/responsive.css">
	
	
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>


	<section class="tp-br">
		<div class="container">
			<p class="mb-0 text-center text-white">FREE SHIPPING ON ALL ORDERS OVER  $125</p>
		</div>
	</section>
	<header class="theame-header">
		<nav class="navbar navbar-expand-lg custom_navabr">
			<div class="container">
				<a class="navbar-brand light-logo" href="https://businessonline.website/mossbegood.com/"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/logo.png" alt=""></a>
				<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
					<span></span>
					<span></span>
					<span></span>
				</button>
				<div class="collapse navbar-collapse" id="navbarSupportedContent">
					<ul class="navbar-nav ms-auto mb-2 mb-lg-0">
						<li class="nav-item">
							<a class="nav-link  <?php if(is_page('homepage')) {echo "active"; } else{echo "";}?>" aria-current="page" href="https://businessonline.website/mossbegood.com/">Home</a>
						</li>
						<li class="nav-item">
							<a class="nav-link 
									  <?php if(is_page('about-us')) {echo "active"; } else{echo "";}?>" 
			href="https://businessonline.website/mossbegood.com/about-us/">About</a>
						</li>
						<li class="nav-item">
							<a class="nav-link <?php if(is_page('shop')) {echo "active"; } else{echo "";}?>" href="https://businessonline.website/mossbegood.com/shop/">SHOP</a>
						</li>
						<li class="nav-item">
							<a class="nav-link <?php if(is_page('reviews')) {echo "active"; } else{echo "";}?>" href="https://businessonline.website/mossbegood.com/reviews/">REVIEWS</a>
						</li>
						<li class="nav-item">
							<a class="nav-link <?php if(is_page('order-tracking')) {echo "active"; } else{echo "";}?>" href="https://businessonline.website/mossbegood.com/order-tracking/">ORDER TRACKING</a>
						</li>
						<li class="nav-item">
							<a class="nav-link <?php if(is_page('contact-us')) {echo "active"; } else{echo "";}?>" href="https://businessonline.website/mossbegood.com/contact-us/">CONTATCT US</a>
						</li>
					</ul>
					<div class="h-social-links">
						<a href="javascript:void(0);"><i class="far fa-search"></i></a>
						<a href="https://businessonline.website/mossbegood.com/my-account/"><i class="far fa-user"></i></a>
						<a href="https://businessonline.website/mossbegood.com/cart/"><i class="far fa-cart-plus"></i></a>
					</div>
					
				</div>
			</div>
		</nav>
	</header>